import matplotlib.pyplot as plt
import numpy as np
from scipy.interpolate import splrep, BSpline
from scipy import interpolate
import os
from matplotlib.cm import get_cmap

plt.rc('font',family='Helvetica')

Spring_constant_water = 2.65 # nN/nm
ylg_water=0.035
blunt_length = 66

# Create a colormap
cmap = get_cmap("plasma")  # You can choose any colormap you prefer
fig, (ax_left, ax_right) = plt.subplots(1, 2, figsize=(6, 4), sharex=True)
def extract_number_from_curve_name(curve_name):
    match = re.search(r'(\d+)', curve_name)
    if match:
        return int(match.group())
    return float('inf')  # Use a large number for names without numbers


cone_angle_value = 26.0
set_linewidth=1.2

color_list_normalized = [
    "#03045E",  # Dark Slate Blue
    "#007786",  # Steel Blue
    "#00B4D8",  # Light Blue
    "#90E0EF",# Light Coral
    "#BCD2E8",  # Coral

    "#32612D", #basil
    "#028A0F",#grass
    "#3DED97",#lightgreen,
    "#f2c85b",
    "#F86E51",  # Tomato
    "#EE3E38",  # Cinnabar
    "#D1193E",  # Indian Red
    "#8B0000",
    'black', # Dark Red
]# Crimson


folder_path = '/Contact_angle_AFM_simulation (Fig_5)/simulation'
os.chdir(folder_path)

SMALL_SIZE = 10
MEDIUM_SIZE = 10
BIGGER_SIZE = 10
n = 6
fitted_slope = []
fitted_intercept = []

def see_force (input_file, k, shift_by_final,q_fit,position_correction, ax):

    # Get the name of the input file as a string
    curve_full_name = str(input_file)
    curve_name = str(curve_full_name.split('_')[-4])
    cone_angle.append(float(curve_name))
    print('strat processing', curve_full_name)

    f=open(input_file, "r")
    lines=f.readlines()
    energy=[]
    extra = []
    position=[]
    for x in lines:
        energy.append(x.split('\t')[1])
        position.append(x.split('\t')[0])

    position_corrected = []
    energy_corrected = []
    for i in position:
        position_corrected.append(float((i.strip())))
    for j in energy:
        energy_corrected.append(float((j.strip())))


    array_energy = np.array(energy_corrected)
    if shift_by_final == 'TRUE':
        shifted_energy = array_energy - np.average(array_energy[-1])
    else:
        shifted_energy = array_energy - np.average(array_energy[-int(len(array_energy) / 3)::])
    array_position = np.array(position_corrected)+position_correction
    chopped_position = array_position[0:-1]

    target_file_name = curve_full_name

    # Open the data file for reading
    with open("sp_fit_source.txt", "r") as file_source:
        for line in file_source:
            parts = line.split()
            if len(parts) == 2:
                curve_full_name, sp_fit_cut = parts
                if curve_full_name == target_file_name:
                    sp_fit_cut = int(sp_fit_cut)  # Convert to integer
                    print(f"The number associated with '{target_file_name}' is: {sp_fit_cut}")
                    print('the type is',type(sp_fit_cut))
                    break
        else:
            print(f"No entry found for '{target_file_name}'")


    plt.xticks(fontsize=SMALL_SIZE)
    plt.yticks(fontsize=SMALL_SIZE)
    print('hi')
    # simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(str(curve_full_name.split('_')[6])) / 2))
    simulation_blunt_length = 0.0075 * np.tan(np.deg2rad(float(cone_angle_value) / 2))
    print('simulation_blunt_length', simulation_blunt_length)
    if q_fit == 'True':
        s = 1
        tck = interpolate.splrep(array_position[:sp_fit_cut], shifted_energy[:sp_fit_cut], s=s)

        # Get the coefficients of the fitted spline
        coeffs = tck[1]

        # The coefficients include the quadratic term at index 2
        a = coeffs[2]
        quadratic_constants.append(a)

        sp_fit_cut = int(sp_fit_cut)
        xnew = np.linspace(array_position[0], array_position[sp_fit_cut], 100)
        # plt.plot(xnew, BSpline(*tck)(xnew, 0), '-', color='blue', label = name+'fit energy then get gradient')
        print('simulation_blunt_length', simulation_blunt_length)
        ax.plot(xnew/simulation_blunt_length, -BSpline(*tck)(xnew, 1)/simulation_blunt_length, '-', color = color_list_normalized[k], label = r'$\alpha$'+ '='+curve_name+u'\N{DEGREE SIGN}',linewidth=set_linewidth,alpha=0.9)
        adhesion_force.append(-(-BSpline(*tck)(xnew, 1)[0]))

        x_flat = [xnew[-1],array_position[sp_fit_cut], array_position[-1], 1]

        y_flat = [-BSpline(*tck)(xnew[-1], 1), 0, 0, 0]
        # Plot a vertical line at x=2

        ax.plot((x_flat) / simulation_blunt_length, y_flat / simulation_blunt_length, '-', color=color_list_normalized[k], zorder=5,
                 linewidth=set_linewidth, alpha=0.9)
    else:

        s = 1
        tck = interpolate.splrep(array_position[:sp_fit_cut], shifted_energy[:sp_fit_cut],s=s)
        xnew = np.linspace(array_position[0], array_position[sp_fit_cut], 1000)
        ynew_prime = interpolate.splev(xnew, tck, der=1)
        ax.plot(xnew/simulation_blunt_length, -ynew_prime/simulation_blunt_length, '-',label = curve_name ,  color=color_list_normalized[k], linewidth=set_linewidth,zorder=3,alpha=0.9)
        x_flat = [xnew[-1], array_position[sp_fit_cut], array_position[-1], 1]

        y_flat = [-BSpline(*tck)(xnew[-1], 1), 0, 0, 0]
        ax.plot((x_flat) / simulation_blunt_length, y_flat / simulation_blunt_length, '-',
                          color=color_list_normalized[k], zorder=3,
                          linewidth=set_linewidth, alpha=0.9)


# List all the .txt files in the folder
txt_files = [f for f in os.listdir(folder_path) if f.endswith('0.0075.txt') and f.startswith('3107_ca_condition_0.0002_cone_angle_26')]

def myFunc(file_name):
  return float(str(file_name.split('_')[-4]))

# Sort the files based on the numeric part of curve_name
txt_files.sort(key=myFunc)

print('file_list', txt_files)

quadratic_constants = []  # Array to store quadratic constants
cone_angle = []
adhesion_force = []
 # Process each .txt file and create a subplot for each

k = 0
for i, txt_file in enumerate(txt_files):
    position_value = float(str(txt_file.split('_')[-4]))
    print(f"Processing file {i + 1}/{len(txt_files)}: {txt_file}, Position Value: {position_value}")
    input_file = txt_file
    see_force(input_file, k, shift_by_final='TRUE',q_fit='none',position_correction=0, ax=ax_right)
    print('k', k)
    k += 1


plt.xlim(-3,6)
# plt.xticks(np.linspace(-3.5, 8, num=5))

# Adjust layout parameters to ensure y-axis label visibility
plt.subplots_adjust(left=0.15, right=0.85, bottom=0.15, top=0.9)
# Save the figure with a full path

# in air
Spring_constant_air = 2.57 # nN/nm
blunt_length= 66
# blunt_length= 40
ylg_air=0.02
color='#03045E'
color2='#52b2bf'

#####Air
def process_input_file(input_file):

    # Get the name of the input file as a string
    file_name = input_file
    # curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        first_x = float(info_line.split(',')[0].split(' ')[3])
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
        print('first_x', first_x)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True


    # put into an array in Force
    deflection_data_array = np.array(deflection_data) * Spring_constant_air

    position_array = np.arange(first_x, (len(deflection_data_array) + 2) * position_interval, position_interval).astype(
            float)
    position_array = position_array[:len(deflection_data_array)]+ deflection_data_array / Spring_constant_air


    print('x_len', len(position_array))
    print('y_len', len(deflection_data_array))

    position_array = position_array*1e9/(blunt_length / 2)
    deflection_data_array = deflection_data_array*1e9/(blunt_length / 2 * ylg_air)
    deflection_data_array = deflection_data_array+0.85
    # Return deflection data array and position array
    return deflection_data_array, position_array



def process_error(input_file, ax):

    # Get the name of the input file as a string
    file_name = input_file
    # curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        first_x = float(info_line.split(',')[0].split(' ')[3])
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
        print('first_x', first_x)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    error_deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                error_deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True


    # put into an array in Force
    error_data_array = np.array(error_deflection_data) * Spring_constant_air

    error_position_array = np.arange(first_x, (len(error_data_array) + 2) * position_interval, position_interval).astype(
            float)
    error_position_array = error_position_array[:len(error_data_array)]+error_data_array / Spring_constant_air


    print('x_len', len(error_position_array))
    print('error_len', len(error_data_array))

    error_position_array = error_position_array * 1e9 / (blunt_length / 2)
    error_data_array = error_data_array * 1e9 / (blunt_length / 2 * ylg_air)

    return error_data_array, error_position_array

# Specify the folder containing the .txt files
folder_path = '/Contact_angle_AFM_simulation (Fig_5)/AFM'
os.chdir(folder_path)

# Process input file
show_from=230
deflection_data, position_array = process_input_file('T5air_avg_Defl.txt')
ax_left.plot(position_array[show_from:], deflection_data[show_from:], label='Exp in air '+ r'$\theta$'+'= 5', linewidth=set_linewidth, alpha=0.7, color=color)
ax_left.plot(position_array[show_from:], deflection_data[show_from:], label='Exp in air '+ r'$\theta$'+'= 5', linewidth=set_linewidth, alpha=0.7, color=color)

# Process error file
error_data, error_position = process_error('T5air_avgSDV_Defl.txt', ax=ax_left)

# Calculate upper and lower bounds for shaded area
upper_bound = (deflection_data + error_data)
lower_bound = (deflection_data - error_data)

# Shade the area between the curves
ax_left.fill_between(position_array[show_from:], lower_bound[show_from:], upper_bound[show_from:], color=color2, alpha=0.6, edgecolor='none')

# Water
Spring_constant_water = 2.65 # nN/nm
ylg_water=0.035


def process_input_file_new(input_file, ax):

    # Get the name of the input file as a string
    file_name = input_file
    # curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        first_x = float(info_line.split(',')[0].split(' ')[3])
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
        print('first_x', first_x)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True


    # put into an array in Force
    deflection_data_array = np.array(deflection_data)*Spring_constant_water

    position_array = np.arange(first_x, (len(deflection_data_array) + 2) * position_interval, position_interval).astype(
            float)
    position_array = position_array[:len(deflection_data_array)]+deflection_data_array/Spring_constant_water
    position_array = position_array*1e9/(blunt_length/2)
    deflection_data_array = deflection_data_array*1e9/(blunt_length/2*ylg_water)

    print('x_len', len(position_array))
    print('y_len', len(deflection_data_array))



    # Return deflection data array and position array
    return deflection_data_array, position_array



def process_error_new(input_file, ax):

    # Get the name of the input file as a string
    file_name = input_file
    # curve_name = str(file_name.split('_')[-4])
    print('strat processing',file_name)

    with open(input_file, 'r') as file:
        for line in file:
            if line.startswith('X SetScale/P'):
                info_line = line

    # Print the last line
    if info_line:
        print('info_line:', info_line)
        first_x = float(info_line.split(',')[0].split(' ')[3])
        position_interval = float(info_line.split(',')[1])
        print('position interval', position_interval)
        print('first_x', first_x)
    else:
        print('No line starting with "X SetScale/P" found in the input file.')

    # Initialize variables
    error_deflection_data = []  # To store the data

    # Read the input file and collect data
    with open(input_file, 'r') as file:
        data_started = False
        for line in file:
            line = line.strip()
            if data_started:
                if line == "END":
                    break  # Exit the loop when "end" is encountered
                error_deflection_data.append(float(line))  # Convert the line to a float and append it to the data list
            elif line == "BEGIN":
                data_started = True


    # put into an array in Force
    error_data_array = np.array(error_deflection_data)

    error_position_array = np.arange(first_x, (len(error_data_array) + 2) * position_interval, position_interval).astype(
            float)
    error_position_array = error_position_array[:len(error_data_array)]+error_data_array

    error_position_array = error_position_array*1e9/(blunt_length/2)
    error_data_array = error_data_array*1e9/(blunt_length/2*ylg_water)
    print('x_len', len(error_position_array))
    print('error_len', len(error_data_array))

    return error_data_array, error_position_array

# Specify the folder containing the .txt files
folder_path = '/Contact_angle_AFM_simulation (Fig_5)/AFM'
os.chdir(folder_path)

# Create a single figure
color='#8B0000'
color2='#F86E51'
plot_x_shift=0
show_from=230
# Process input file
deflection_data, position_array = process_input_file_new('T5water_avg_Defl.txt', ax=ax_left)
ax_left.plot(position_array[show_from:]+plot_x_shift, deflection_data[show_from:], label='Exp in water '+ r'$\theta$'+'= 100', linewidth=set_linewidth, alpha=0.7, color=color)

# Process error file
error_data, error_position = process_error_new('T5water_avgSDV_Defl.txt', ax=ax_left)


# Calculate upper and lower bounds for shaded area
upper_bound = (deflection_data + error_data)
lower_bound = (deflection_data - error_data)

# Shade the area between the curves
ax_left.fill_between(position_array[show_from:]+plot_x_shift, lower_bound[show_from:], upper_bound[show_from:], color=color2, alpha=0.7)

# Enlarge axis number size

ax_left.set_xlim(-1,8.5)
ax_left.set_ylim(-35,3)
ax_right.set_xlim(-1,8.5)
ax_right.legend(loc=4, frameon=False, ncol=2)


ax_right.set_ylim(-35,3)
ax_right.set_xlabel('$\dfrac{Position}{R}$', fontsize=10)
ax_left.set_xlabel('$\dfrac{Position}{R}$', fontsize=10)
ax_left.set_ylabel('$\dfrac{F}{R\, \\times \, \gamma_{LF}}$', fontsize=10)
ax_left.set_xticks([0,2,4,6,8],fontsize=10)
ax_left.set_yticks([-30,-20,-10,0],fontsize=10)
ax_right.set_xticks([0,2,4,6,8],fontsize=10)
ax_right.set_yticks([-30,-20,-10,0],fontsize=10)
plt.tight_layout()


ax_right.axvspan(-1.8,0,facecolor='gray',alpha=0.15,edgecolor='none',zorder=0)
save_name = 'waterairca.svg'
save_path = '/Users/thornbird/Library/CloudStorage/OneDrive-DurhamUniversity/PhD/Tip/Figure paper/'

# plt.savefig(save_path+save_name,save_name format='svg', bbox_inches='tight',dpi=1200)


plt.show()



